---
obsidianUIMode: preview
---

The guidelines in this section replace the madness rules found in other books. The concept of "madness" has long been used to malign and marginalize complex psychological symptoms and the individuals coping with them.

This new approach works with explicitly supernatural hindrances to break away from those stereotypes.

These effects represent dire reactions to a character witnessing something so alien and horrific that it has a lasting effect. You can use these descriptions to replace the more general frightened, stunned, or incapacitated conditions as desired.

When amplifying a sense of stress or horror in a game, ensure that you have the players' permission ahead of time and that proper safety tools (referenced earlier in this document) are in place.

## Using Stress Effects

Some things are beyond the ability of the mortal mind to comprehend. When witnessing alien or horrific entities, locations, and events, even the most powerful heroes might find their ability to process what unfolds around them shut down, forcing them to make a stress check. Such a check might be warranted by any of the following situations:

* Witnessing a ghoul devouring a body
* Beholding a bloody sacrificial altar
* Watching the raising of the dead
* Witnessing a ritual sacrifice
* Hearing the sermon of a dark priest
* Reading words from a forbidden tome
* Reading glyphs describing an elder evil
* Seeing a parasite burst free from its host
* Beholding unholy primordial cave paintings
* Touching an unholy artifact
* Peering through a portal into the Nine Hells
* Staring into a scrying pool showing the Abyss
* Discovering the ruins of a sentient alien vessel
* Watching depraved acts of cannibalism
* Seeing the true form of an abomination
* Falling into the depths of the Astral Plane
* Staring into the tumultuous extents of Limbo
* Standing in the presence of a demon prince
* Beholding an alien city of elder evils
* Witnessing the death of a god

## Stress Results

Whenever a character witnesses a potential stress event, you can ask for a Charisma saving throw with a DC based on the severity of the event, from DC 10 (easy) to DC 20 (hard). On a failed save, the character suffers a roleplaying effect from the Stress Effects list. Make sure you review the effects on the table during session zero to ensure they don't cross any players' lines of comfort.

## 1d20 Stress Results

`dice: [[23 - Stress Effects#^1d20-stress-results]]`

1. You slip into a mental vision of a restful place.
2. You whisper in a tongue no mortal understands.
3. Blood flows from your eyes.
4. You collapse as you lose all strength.
5. A screaming whine fills your hearing.
6. Your heart seems to stop in your chest.
7. The faces of your friends hideously contort.
8. Your heartbeat hammers in your ears.
9. You hear strange, discordant music.
10. You fall asleep and dream of darkness.
11. A terrible memory of your past comes to mind.
12. Physical pain and burning wracks your body.
13. You find yourself unable to move or speak.
14. Unbound shadows seem to crawl toward you.
15. You hear the echoing sound of children crying.
16. You lose control of your bodily functions.
17. Your vision fills with twisted geometric shapes.
18. You hear the whispers of an otherworldly being.
19. You scream as blood flows from your mouth.
20. You feel as though all your bones begin to crack.

^1d20-stress-results

You determine how long the effect lasts and can add mechanical hindrances inspired by the effect at your discretion. Alternatively, you can add the following mechanical effect:

On a failed save, the character becomes stunned for 1 minute. The character can repeat the saving throw at the end of each of their turns and whenever they take damage, ending the effect on themself on a success. If the character's saving throw is successful or if the effect ends for it, the character is immune to this effect for the next 24 hours. A character can also choose to break this effect at the start of their turn by taking 4 (1d8) psychic damage per two character levels. A *lesser restoration* or equivalent effect likewise negates a stress effect.

(You can also apply this mechanism for breaking an effect by taking psychic damage to characters who are frightened, stunned, or incapacitated.)

## Long-Term Effects

GMs and players can work together to determine whether stress effects have longer-term ramifications. Any such long-term results should reflect not just the character and the situation, but also the players' desires.

Be mindful to avoid terms such as "madness" or "crazy" to describe the long-term effects of stressful encounters. Consider instead the otherworldly nature of the situation and effect, and focus on how the character might respond to such a stressful experience.

Special thanks to Dr. Megan Connell and Dr. Michael Mallen for their feedback on this section.
